//
//  FTPointArray.h
//  GSFontTools
//
//  Created by Georg Seifert on 19/03/16.
//
//

#import <Foundation/Foundation.h>

#define FTPointsEqual(A, B, threshold) (fabs(A.x - B.x) < threshold && fabs(A.y - B.y) < threshold)

@interface FTPointArray : NSObject <NSCopying>

- (instancetype)initWithCapacity:(NSUInteger)capacity;

/// @param array Can contain arrays of two `NSNumber` objects, individual `NSNumber` objects (for the single value case), or `NSNull` instances (for `{NSNotFound, 0}`).
+ (instancetype)pointArrayWithArray:(NSArray *)array;

- (instancetype)copySubarrayWithRange:(NSRange)range NS_RETURNS_RETAINED;

- (void)addPoint:(NSPoint)point;
- (void)addPointsFromPointArray:(FTPointArray *)array;
- (void)insertPoint:(NSPoint)point atIndex:(NSUInteger)idx;

/// If `idx` is equal to `count`, adds the point at the end. If `idx` is less than `count`, replaces the point at `idx`.
- (void)setPoint:(NSPoint)point atIndex:(NSUInteger)idx;

- (void)removePointAtIndex:(NSUInteger)idx;
- (void)removeAllPoints;

@property (nonatomic, readonly) NSUInteger count;
- (NSPoint)pointAtIndex:(NSUInteger)idx;
@property (nonatomic, readonly) NSPoint firstPoint;
@property (nonatomic, readonly) NSPoint lastPoint;

@property (nonatomic, readonly) NSPointArray points;

- (BOOL)containsPoint:(NSPoint)point threshold:(CGFloat)threshold;

//- (id)objectAtIndexedSubscript:(*IndexType*)idx;
//- (void)setObject:(id)obj atIndexedSubscript:(*IndexType*)idx;

@end
